#include <iostream>
#include <type_traits>

template <typename T, typename = void>
struct is_printable : std::false_type {};

template <typename T>
struct is_printable<T, std::void_t<decltype(std::cout << std::declval<T>())>> : std::true_type {};

template <typename T>
void print(const T& value) {
    if constexpr (is_printable<T>::value) {
        std::cout << "Printing: " << value << std::endl;
    } else {
        std::cout << "Cannot print this type" << std::endl;
    }
}

struct NonPrintable {};

int main() {
    print(42);
    print("Hello");
    print(NonPrintable{});

    return 0;
}
