#include <iostream>
#include <type_traits>

template <typename T, typename U>
class Pair {
public:
    Pair(T first, U second) : first_(first), second_(second) {
        std::cout << "Generic Pair" << std::endl;
    }

    void display() {
        std::cout << "First: " << first_ << ", Second: " << second_ << std::endl;
    }

private:
    T first_;
    U second_;
};

template <typename T>
class Pair<T, T> {
public:
    Pair(T first, T second) : first_(first), second_(second) {
        std::cout << "Specialized Pair for same types" << std::endl;
    }

    void display() {
        std::cout << "Both: " << first_ << ", " << second_ << std::endl;
    }

private:
    T first_;
    T second_;
};

int main() {
    Pair<int, double> p1(1, 2.5);
    Pair<int, int> p2(3, 4);

    p1.display();
    p2.display();

    return 0;
}
