// for std::move
#include <utility>  
#include <iostream>  
using namespace std;

class MyClass {
public:
    MyClass() { std::cout << "MyClass Constructor" << std::endl; }
    ~MyClass() { std::cout << "MyClass Destructor" << std::endl; }
    void sayHello() const { std::cout << "Hello from MyClass" << std::endl; }
};

int main()
{
    std::unique_ptr<MyClass> ptr1 = std::make_unique<MyClass>();
    //std::unique_ptr<MyClass> ptr3 = std::move(ptr1);  // not valid
    //std::unique_ptr<MyClass> ptr2 = ptr1; // not valid

    std::shared_ptr<MyClass> ptr11 = std::make_shared<MyClass>();
    cout << "count(ptr11): " << ptr11.use_count() << endl; // count: 1
    // std::shared_ptr<MyClass>& ptr13 = std::move(ptr11); // invalid 

    const std::shared_ptr<MyClass>& ptr13 = std::move(ptr11); 
    cout << "count(ptr13): " << ptr13.use_count() << endl; // count: 1

    std::shared_ptr<MyClass>& ptr12 = ptr11;  // does not increase count
    cout << "count(ptr12): " << ptr12.use_count() << endl; // count: 1

    std::shared_ptr<MyClass> ptr14 = ptr11;
    cout << "count(ptr14): " << ptr14.use_count() << endl; // count: 2
    return 0;
}

