#include <iostream>
#include <memory>
#include <cstdio>  // For FILE*

struct FileDeleter {
    void operator()(FILE* fp) const {
        if (fp) {
            std::cout << "Closing file" << std::endl;
            std::fclose(fp);
        }
    }
};

int main() {
    std::unique_ptr<FILE, FileDeleter> filePtr(std::fopen("example.txt", "w"));

    if (filePtr) {
        std::fprintf(filePtr.get(), "Hello, file!\n");
    }

    // filePtr goes out of scope, and FileDeleter is invoked to close the file

    return 0;
}

