#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    std::vector<std::pair<std::string, int>> items = {
        {"apple", 5},
        {"banana", 2},
        {"cherry", 8},
        {"date", 1}
    };
    
    // Sort by the second element of the pair (the integer)
    std::sort(items.begin(), items.end(), 
              [](const auto& a, const auto& b) { return a.second < b.second; });
    
    std::cout << "Sorted by quantity:" << std::endl;
    for (const auto& item : items) {
        std::cout << item.first << ": " << item.second << std::endl;
    }
    
    return 0;
}
