#include <iostream>
#include <type_traits>
#include <string>

class MyClass {
public:
    template <typename T>
    typename std::enable_if<std::is_integral<T>::value, void>::type
    print(T value) {
        std::cout << "Integral type: " << value << std::endl;
    }

    template <typename T>
    typename std::enable_if<std::is_floating_point<T>::value, void>::type
    print(T value) {
        std::cout << "Floating-point type: " << value << std::endl;
    }

    template <typename T>
    typename std::enable_if<std::is_same<T, std::string>::value, void>::type
    print(const T& value) {
        std::cout << "String type: " << value << std::endl;
    }
};

int main() {
    MyClass obj;
    obj.print(42);
    obj.print(3.14);
    obj.print(std::string("Hello"));
    return 0;
}
