#include <iostream>
#include <vector>
#include <string>

struct Data {
    std::vector<int> values;
    
    Data(std::initializer_list<int> list) : values(list) {
        std::cout << "Constructing Data with " << values.size() << " elements" << std::endl;
    }
    
    friend std::ostream& operator<<(std::ostream& os, const Data& data) {
        os << "Data: ";
        for (int val : data.values) {
            os << val << " ";
        }
        return os;
    }
};

int main() {
    std::vector<Data> dataVector;
    
    // Correct usage of emplace_back with initializer lists
    dataVector.emplace_back(std::initializer_list<int>{1, 2, 3, 4, 5});
    dataVector.emplace_back(std::initializer_list<int>{10, 20, 30});
    
    // Alternative approach using push_back
    dataVector.push_back({100, 200, 300});
    
    for (const auto& data : dataVector) {
        std::cout << data << std::endl;
    }
    
    return 0;
}
