#include <iostream>
#include <vector>
#include <string>

struct ComplexObject {
    std::string name;
    int id;
    double value;
    
    ComplexObject(std::string n, int i, double v) 
        : name(std::move(n)), id(i), value(v) {
        std::cout << "Constructing ComplexObject: " << name << std::endl;
    }
    
    friend std::ostream& operator<<(std::ostream& os, const ComplexObject& obj) {
        return os << obj.name << " (ID: " << obj.id << ", Value: " << obj.value << ")";
    }
};

int main() {
    std::vector<ComplexObject> objects;
    
    objects.emplace_back("Object1", 1, 3.14);
    objects.emplace_back("Object2", 2, 2.718);
    
    for (const auto& obj : objects) {
        std::cout << obj << std::endl;
    }
    
    return 0;
}
