#include <iostream>
#include <vector>
#include <algorithm>
#include <string>

int main(int argc, char* argv[]) {
    if (argc < 2) {
        std::cerr << "Usage: " << argv[0] << " <word1> [word2] [word3] ..." << std::endl;
        return 1;
    }

    std::vector<std::string> words(argv + 1, argv + argc);

    std::cout << "Original words:" << std::endl;
    for (const auto& word : words) {
        std::cout << word << " ";
    }
    std::cout << std::endl;

    std::sort(words.begin(), words.end());

    std::cout << "Sorted words:" << std::endl;
    for (const auto& word : words) {
        std::cout << word << " ";
    }
    std::cout << std::endl;

    return 0;
}
