#include <iostream>
#include <string>
#include <cstdlib>

int main(int argc, char* argv[]) {
    if (argc != 4) {
        std::cerr << "Usage: " << argv[0] << " <number1> <operation> <number2>" << std::endl;
        return 1;
    }

    double num1 = std::atof(argv[1]);
    std::string op = argv[2];
    double num2 = std::atof(argv[3]);
    double result;

    if (op == "+") result = num1 + num2;
    else if (op == "-") result = num1 - num2;
    else if (op == "*") result = num1 * num2;
    else if (op == "/") {
        if (num2 == 0) {
            std::cerr << "Error: Division by zero" << std::endl;
            return 1;
        }
        result = num1 / num2;
    }
    else {
        std::cerr << "Error: Invalid operation" << std::endl;
        return 1;
    }

    std::cout << "Result: " << result << std::endl;
    return 0;
}
