#include <iostream>
#include <string>

class Animal {
protected:
    std::string name;

public:
    Animal(const std::string& n = "") : name(n) {}

    Animal& operator=(const Animal& other) {
        if (this != &other) {
            name = other.name;
        }
        return *this;
    }

    virtual void speak() const {
        std::cout << name << " makes a sound." << std::endl;
    }
};

class Dog : public Animal {
private:
    std::string breed;

public:
    Dog(const std::string& n = "", const std::string& b = "") : Animal(n), breed(b) {}

    Dog& operator=(const Dog& other) {
        if (this != &other) {
            Animal::operator=(other);  // Call base class assignment operator
            breed = other.breed;
        }
        return *this;
    }

    void speak() const override {
        std::cout << name << " the " << breed << " barks." << std::endl;
    }
};

int main() {
    Dog d1("Buddy", "Labrador");
    Dog d2;
    d2 = d1;  // Assignment operator called
    
    d1.speak();  // Output: Buddy the Labrador barks.
    d2.speak();  // Output: Buddy the Labrador barks.
    
    return 0;
}
