#include <iostream>
#include <utility>

class Resource {
private:
    int* data;
    size_t size;

public:
    Resource(size_t n = 0) : size(n), data(n ? new int[n]() : nullptr) {}

    ~Resource() {
        delete[] data;
    }

    // Copy assignment operator
    Resource& operator=(const Resource& other) {
        if (this != &other) {
            delete[] data;
            size = other.size;
            data = new int[size];
            std::copy(other.data, other.data + size, data);
        }
        return *this;
    }

    // Move assignment operator
    Resource& operator=(Resource&& other) noexcept {
        if (this != &other) {
            delete[] data;
            data = other.data;
            size = other.size;
            other.data = nullptr;
            other.size = 0;
        }
        return *this;
    }

    void print() const {
        for (size_t i = 0; i < size; ++i) {
            std::cout << data[i] << " ";
        }
        std::cout << std::endl;
    }
};

int main() {
    Resource r1(5);
    Resource r2;
    
    // Copy assignment
    r2 = r1;
    
    // Move assignment
    Resource r3;
    r3 = std::move(r1);
    
    r2.print();  // Output: 0 0 0 0 0
    r3.print();  // Output: 0 0 0 0 0
    r1.print();  // Output: (empty, as r1 has been moved from)
    
    return 0;
}
