#include <iostream>
#include <cstring>

class String {
private:
    char* data;
    size_t length;

public:
    String(const char* str = "") : length(strlen(str)) {
        data = new char[length + 1];
        strcpy(data, str);
    }

    ~String() {
        delete[] data;
    }

    // Copy assignment operator
    String& operator=(const String& other) {
        if (this != &other) {
            delete[] data;
            length = other.length;
            data = new char[length + 1];
            strcpy(data, other.data);
        }
        return *this;
    }

    void print() const {
        std::cout << data << std::endl;
    }
};

int main() {
    String s1("Hello");
    String s2;
    s2 = s1;  // Assignment operator called
    
    s1.print();  // Output: Hello
    s2.print();  // Output: Hello
    
    return 0;
}
