#include <iostream>
#include <initializer_list>
#include <vector>
#include <set>
#include <map>

template<typename T>
void printContainer(const T& container) {
    for (const auto& item : container) {
        std::cout << item << " ";
    }
    std::cout << std::endl;
}

int main() {
    // Vector
    std::vector<int> vec = {1, 2, 3, 4, 5};
    std::cout << "Vector: ";
    printContainer(vec);

    // Set
    std::set<char> charSet = {'a', 'b', 'c', 'd', 'e'};
    std::cout << "Set: ";
    printContainer(charSet);

    // Map
    std::map<std::string, int> ageMap = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 35}
    };
    std::cout << "Map: " << std::endl;
    for (const auto& pair : ageMap) {
        std::cout << pair.first << ": " << pair.second << std::endl;
    }

    return 0;
}
