#include <iostream>
#include <initializer_list>
#include <vector>
#include <string>

class Team {
private:
    std::string name;
    std::vector<std::string> members;

public:
    Team(const std::string& teamName) : name(teamName) {
        std::cout << "Team created with name only" << std::endl;
    }

    Team(const std::string& teamName, std::initializer_list<std::string> memberList)
        : name(teamName), members(memberList) {
        std::cout << "Team created with name and member list" << std::endl;
    }

    void display() const {
        std::cout << "Team: " << name << std::endl;
        std::cout << "Members: ";
        for (const auto& member : members) {
            std::cout << member << " ";
        }
        std::cout << std::endl;
    }
};

int main() {
    Team team1("Avengers");
    team1.display();

    Team team2("Justice League", {"Superman", "Batman", "Wonder Woman"});
    team2.display();

    return 0;
}
