#include <iostream>
#include <initializer_list>
#include <numeric>

double average(std::initializer_list<double> list) {
    if (list.size() == 0) return 0;
    return std::accumulate(list.begin(), list.end(), 0.0) / list.size();
}

void printValues(std::initializer_list<int> list) {
    for (int value : list) {
        std::cout << value << " ";
    }
    std::cout << std::endl;
}

int main() {
    std::cout << "Average: " << average({1.0, 2.0, 3.0, 4.0, 5.0}) << std::endl;
    std::cout << "Average: " << average({10.5, 20.5, 30.5}) << std::endl;

    printValues({1, 2, 3, 4, 5});
    printValues({100, 200, 300});

    return 0;
}
