#include <iostream>
#include <initializer_list>
#include <vector>

template<typename T>
class MyContainer {
private:
    std::vector<T> data;

public:
    MyContainer(std::initializer_list<T> list) : data(list) {
        std::cout << "Constructed with " << list.size() << " elements." << std::endl;
    }

    void print() const {
        for (const auto& item : data) {
            std::cout << item << " ";
        }
        std::cout << std::endl;
    }
};

int main() {
    MyContainer<int> c1 = {1, 2, 3, 4, 5};
    c1.print();

    MyContainer<std::string> c2 = {"Hello", "World", "!"};
    c2.print();

    return 0;
}
