#include <iostream>
#include <list>
#include <string>
#include <algorithm>

class Person {
public:
    std::string name;
    int age;

    Person(const std::string& n, int a) : name(n), age(a) {}

    // For sorting based on age
    bool operator<(const Person& other) const {
        return age < other.age;
    }
};

// For displaying Person objects
std::ostream& operator<<(std::ostream& os, const Person& p) {
    return os << p.name << " (" << p.age << ")";
}

int main() {
    std::list<Person> people = {
        {"Alice", 30},
        {"Bob", 25},
        {"Charlie", 35},
        {"David", 28}
    };

    // Display original list
    std::cout << "Original list:" << std::endl;
    for (const auto& person : people) {
        std::cout << person << std::endl;
    }

    // Sort the list based on age
    people.sort();

    // Display sorted list
    std::cout << "\nSorted list by age:" << std::endl;
    for (const auto& person : people) {
        std::cout << person << std::endl;
    }

    // Find a person by name
    auto it = std::find_if(people.begin(), people.end(),
                           [](const Person& p) { return p.name == "Charlie"; });
    if (it != people.end()) {
        std::cout << "\nFound: " << *it << std::endl;
    }

    return 0;
}
