#include <iostream>
#include <forward_list>
#include <algorithm>

int main() {
    std::forward_list<int> myForwardList = {3, 1, 4, 1, 5, 9};

    // Insert at the beginning
    myForwardList.push_front(0);

    // Insert after a specific position
    auto it = myForwardList.begin();
    std::advance(it, 2);
    myForwardList.insert_after(it, 2);

    // Display the list
    std::cout << "Forward list contents: ";
    for (const auto& elem : myForwardList) {
        std::cout << elem << " ";
    }
    std::cout << std::endl;

    // Remove all elements with a specific value
    myForwardList.remove(1);

    // Reverse the list
    myForwardList.reverse();

    // Display the modified list
    std::cout << "Modified forward list: ";
    for (const auto& elem : myForwardList) {
        std::cout << elem << " ";
    }
    std::cout << std::endl;

    return 0;
}
